''' <summary>
''' Klasa SurveyBase definiuje oglne zachowanie ankiety 
''' </summary>
''' <remarks>Ta klasa bazowa stosuje sowo kluczowe MustInherit; jej egzemplarze nie mog by tworzone bezporednio.</remarks>
Public MustInherit Class SurveyBase

#Region "Zmienne prywatne"

    Private _id As Integer = -1
    Private _name As String = String.Empty
    Private _description As String = String.Empty

#End Region

#Region "Konstruktor(y)"

    ''' <summary>
    ''' Konstruktor domylny
    ''' </summary>
    Public Sub New()

    End Sub

    ''' <summary>
    ''' Tworzy nowy egzemplarz SurveyBase i ustawia jego wewntrzny identyfikator.
    ''' </summary>
    Public Sub New(ByVal id As Integer)
        _id = id
    End Sub

#End Region

#Region "Metody publiczne"

    ''' <summary>
    ''' Definiuje metod Save dla kadej z klas potomnych dziedziczcych po SurveyBase.
    ''' </summary>
    ''' <remarks></remarks>
    Public MustOverride Function Save() As Integer

#End Region

#Region "Waciwoci publiczne"

    ''' <summary>
    ''' Zwraca identyfikator ankiety w bazie danych.
    ''' </summary>
    Public ReadOnly Property Id() As Integer
        Get
            Return _id
        End Get
    End Property

    ''' <summary>
    ''' Pobiera lub ustawia nazw ankiety w bazie danych.
    ''' </summary>
    Public Property Name() As String
        Get
            Return _name
        End Get
        Set(ByVal value As String)
            _name = value
        End Set
    End Property

    ''' <summary>
    ''' Pobiera lub ustawia w bazie danych opis ankiety.
    ''' </summary>
    Public Property Description() As String
        Get
            Return _description
        End Get
        Set(ByVal value As String)
            _description = value
        End Set
    End Property

   
#End Region

End Class
